[![Build Status](https://travis-ci.org/jonathanepollack/gulp-minify-css.png?branch=master)](https://travis-ci.org/jonathanepollack/gulp-minify-css)

## Regarding Issues
This is just a simple gulp plugin, which means it's nothing more than a thin wrapper around `clean-css`. If it looks like you are having CSS related issues, please contact <a href="https://github.com/GoalSmashers/clean-css">clean-css</a>. Only create a new issue if it looks like you're having a problem with the plugin itself.

## Information

<table>
<tr> 
<td>Package</td><td>gulp-minify-css</td>
</tr>
<tr>
<td>Description</td>
<td>Minify css with <a href="https://github.com/GoalSmashers/clean-css">clean-css</a>, including optional caching.</td>
</tr>
<tr>
<td>Node Version</td>
<td>>= 0.10</td>
</tr>
</table>

## Installion

```
npm install --save-dev gulp-minify-css
```

## Usage

```js
var gulp = require('gulp'),
		minifyCSS = require('gulp-minify-css');

gulp.task('minify-css', function() {
  gulp.src('./static/css/*.css')
    .pipe(minifyCSS({keepBreaks:true}))
    .pipe(gulp.dest('./dist/'))
});
```
### Options
* `cache` - check and return minified CSS from cache if it exists; minify and store in cache when it does not

This is a gulp-minify-css feature and not a [clean-css](https://github.com/GoalSmashers/clean-css/) feature.

___

* `keepSpecialComments` - `*` for keeping all (default), `1` for keeping first one only, `0` for removing all
* `keepBreaks` - whether to keep line breaks (default is `false`)
* `benchmark` - turns on benchmarking mode measuring time spent on cleaning up
  (run `npm run bench` to see example)
* `root` - path to resolve absolute `@import` rules and rebase relative URLs
* `relativeTo` - path with which to resolve relative `@import` rules and URLs
* `processImport` - whether to process `@import` rules
* `noRebase` - whether to skip URLs rebasing
* `noAdvanced` - set to true to disable advanced optimizations - selector & property merging, reduction, etc.
* `compatibility` - Force compatibility mode to `ie7` or `ie8`. Defaults to not set.
* `debug` - set to true to get minification statistics under `stats` property (see `test/custom-test.js` for examples)

Source: [clean-css](https://github.com/GoalSmashers/clean-css/blob/80f2d2cdbbe061c49ed1bfd0653edcb50dbebf57/README.md)

### Source maps
Source maps can be generated by using [gulp-sourcemaps](https://www.npmjs.org/package/gulp-sourcemaps):

```js
var gulp = require('gulp');
var minifyCSS = require('gulp-minify-css');
var sourcemaps = require('gulp-sourcemaps');

gulp.task('minify-css', function() {
  gulp.src('./src/*.css')
    .pipe(sourcemaps.init())
    .pipe(minifyCSS())
    .pipe(sourcemaps.write())
    .pipe(gulp.dest('dist'));
});
```
#### Caveats

When minifying (and import inlining) files with existing source map, be aware clean-css doesn't yet support source maps with inline source (`sourcesContent` property).. See [#397](https://github.com/GoalSmashers/clean-css/issues/397).  As such ensure that incoming source maps have properly set `sourceRoot` and `soureces` values to map back to the original source files. 

## LICENSE

(MIT License)

Copyright (c) 2013 Jonathan Pollack (<jonathanepollack@gmail.com>), Cloublabs Inc.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
