angular.module('starter.controllers', [])

    .controller('MainCtrl', function (constants, $scope, $ionicLoading, feqhiatService, $state, utilService, $localStorage) {
        $ionicLoading.show({
            template: 'الرجاء الانتظار'
        });

        var successAllData = function () {
            // save the data to local storage and use it
            $localStorage['allData'] = $scope.allData;
            $scope.allItems =  $localStorage['allData'].items;//$scope.allData.items;
            $ionicLoading.hide();
        };

        var successAllParam = function () {
            $ionicLoading.hide();
            // if version is different force to update
            //alert($localStorage['al_params']);
            if(constants.app_version != utilService.getParamByName("app_version", $scope.al_params).value)
            {
                /// show the update page
                console.log("update");
            }
            // if params not saved before
            else if($localStorage['al_params'] ==  undefined)
            {
                // save it to local storage
                console.log("update DB");
                //console.log(utilService.getParamByName("db_version", $localStorage['al_params']));
                $localStorage['al_params'] = $scope.al_params;
                feqhiatService.getAllData($scope, successAllData);
            }
            else if(utilService.getParamByName("db_version", $localStorage['al_params']).value != utilService.getParamByName("db_version", $scope.al_params).value)
            {
                console.log("update DB 2");
                console.log(utilService.getParamByName("db_version", $localStorage['al_params']));
                $localStorage['al_params'] = $scope.al_params;
                feqhiatService.getAllData($scope, successAllData);
            }
            // check if db version is the same in both server and local
            else //if($window.localStorage['al_params'].db_version == $scope.al_params.db_version)
            {
                $scope.allItems =  $localStorage['allData'].items;//$scope.allData.items;
                $ionicLoading.hide();
            }
            // if not the same, get all data
            //else
            //{
            //    feqhiatService.getAllData($scope, successAllData);
            //}

            // else use the local one
        };

        feqhiatService.getAllParam($scope, successAllParam);

        $scope.navigateToView = function (itemID)
        {
            $state.go('tab.books');
        };
    })

    .controller('BookCtrl',
        function ($scope, feqhiatService, $state, utilService, $localStorage) {
            $scope.allBooks =  $localStorage.allData.books;
        }
    )

    .controller('ChapterCtrl',['$scope', '$http', '$state',
        function($scope, $http, $state) {
            $http.get('data/allData.json').success(function(data) {
                $scope.data = data.data;
                $scope.chapters =  $scope.data.chapters;

                $scope.navigateToView = function (itemID, bookID, chapterID)
                {
                    $state.go('tab.problem_list');
                };

            });
        }
    ])

    .controller('ProblemListCtrl',['$scope', '$http', '$state',
        function($scope, $http, $state) {
            $http.get('data/allData.json').success(function(data) {
                $scope.data = data.data;
                $scope.allBooks =  $scope.data.books;

                $scope.navigateToView = function (itemID)
                {
                    $state.go('tab.books');
                };

            });
        }
    ])

  .controller('SendCtrl', function($scope) {})

  .controller('RecentCtrl', function($scope) {})

  .controller('SearchCtrl', function($scope, Chats) {
  // With the new view caching in Ionic, Controllers are only called
  // when they are recreated or on app start, instead of every page change.
  // To listen for when this page is active (for example, to refresh data),
  // listen for the $ionicView.enter event:
  //
  //$scope.$on('$ionicView.enter', function(e) {
  //});

  $scope.chats = Chats.all();
  $scope.remove = function(chat) {
    Chats.remove(chat);
  };
})

  .controller('AboutCtrl', function($scope) {
    $scope.settings = {
      enableFriends: true
    };
  })

  .controller('ChatDetailCtrl', function($scope, $stateParams, Chats) {
  $scope.chat = Chats.get($stateParams.chatId);
});
