angular.module('starter.controllers', [])

    .controller('MainCtrl', function ($scope, $ionicLoading, feqhiatService, $state) {
        $ionicLoading.show({
            template: 'الرجاء الانتظار'
        });

        var successAllParam = function () {
            $ionicLoading.hide();
            // if version is different force to update

            // else check if db version is the same in both server and local
            // if not the same, get all data
            feqhiatService.getAllData($scope, successAllData);

            // else use the local one
        };
        var successAllData = function () {
            // save the data to local storage and use it
            $ionicLoading.hide();
        };
        feqhiatService.getAllParam($scope, successAllParam);

        $scope.navigateToView = function (itemID)
        {
            $state.go('tab.books');
        };
    })

    .controller('BookCtrl',['$scope', '$http', '$state',
        function($scope, $http, $state) {
            $http.get('data/allData.json').success(function(data) {
                $scope.data = data.data;
                $scope.allBooks =  $scope.data.books;

                $scope.navigateToView = function (itemID, bookID)
                {
                    $state.go('tab.chapters');
                };

            });
        }
    ])

    .controller('ChapterCtrl',['$scope', '$http', '$state',
        function($scope, $http, $state) {
            $http.get('data/allData.json').success(function(data) {
                $scope.data = data.data;
                $scope.chapters =  $scope.data.chapters;

                $scope.navigateToView = function (itemID, bookID, chapterID)
                {
                    $state.go('tab.problem_list');
                };

            });
        }
    ])

    .controller('ProblemListCtrl',['$scope', '$http', '$state',
        function($scope, $http, $state) {
            $http.get('data/allData.json').success(function(data) {
                $scope.data = data.data;
                $scope.allBooks =  $scope.data.books;

                $scope.navigateToView = function (itemID)
                {
                    $state.go('tab.books');
                };

            });
        }
    ])

  .controller('SendCtrl', function($scope) {})

  .controller('RecentCtrl', function($scope) {})

  .controller('SearchCtrl', function($scope, Chats) {
  // With the new view caching in Ionic, Controllers are only called
  // when they are recreated or on app start, instead of every page change.
  // To listen for when this page is active (for example, to refresh data),
  // listen for the $ionicView.enter event:
  //
  //$scope.$on('$ionicView.enter', function(e) {
  //});

  $scope.chats = Chats.all();
  $scope.remove = function(chat) {
    Chats.remove(chat);
  };
})

  .controller('AboutCtrl', function($scope) {
    $scope.settings = {
      enableFriends: true
    };
  })

  .controller('ChatDetailCtrl', function($scope, $stateParams, Chats) {
  $scope.chat = Chats.get($stateParams.chatId);
});
