angular.module('starter.services', [])

    .factory('feqhiatService', function (constants, $http, $rootScope, utilServ, $cordovaSocialSharing,$ionicLoading,$cordovaClipboard) {
        var feqhiatService = {};
        feqhiatService.getAllParam = function (theScope, successFunc) {
            var url = constants.param_url;
            $http({
                method: "GET",
                url: url
            }).success(function (data) {
                var allData = data.data;
                constants.is_admin = allData.is_admin;
                constants.user_name = allData.user_name;

                if (successFunc) {
                    //console.log(constants.is_admin + ",  " + constants.user_name);
                    successFunc();
                }

            }).error(function (data, status) {
                if($ionicLoading)
                    $ionicLoading.hide();
                alert("حدث خطأ ، الرجاء التأكد من الشبكة" );
            });
        };
        feqhiatService.getAllData = function (theScope, successFunc) {
            var url = constants.all_data;
            $http({
                method: "GET",
                url: url
            }).success(function (data) {
                var allData = data.data;
                theScope.allItems =  allData.items;
                if (successFunc) {
                    console.log("success 1");
                    successFunc();
                }

            }).error(function (data, status) {
                if($ionicLoading)
                    $ionicLoading.hide();
                alert("حدث خطأ ، الرجاء التأكد من الشبكة" );
            });
        };

        feqhiatService.getBooks = function (scopeObj, callback, addalloption) {
            var allOptionObj = {
                id: "-1",
                name: "الكل",
                bid: "-1"
            };
            var tempArr = [];

            if ($rootScope.bookList) {
                if (addalloption) {
                    tempArr.push(allOptionObj);
                }

                for (var i = 0; i < $rootScope.bookList.length; i++) {
                    tempArr.push($rootScope.bookList[i]);
                }
                scopeObj.bookList = tempArr;
                if(callback)
                {
                    callback();
                }
                return;
            }

            var burl = constants.booksurl + "?&time=" + Date.now();
            $http({
                method: "GET",
                url: burl
            }).success(function (data) {
                $rootScope.bookList = data.book;
                if (addalloption) {
                    // scopeObj.bookList.push(allOptionObj);
                    tempArr.push(allOptionObj);
                }

                for (var i = 0; i < $rootScope.bookList.length; i++) {
                    // scopeObj.bookList.push($rootScope.bookList[i]);
                    tempArr.push($rootScope.bookList[i]);
                }
                scopeObj.bookList = tempArr;
                if (callback) {
                    callback();
                }
            }).error(function (data, status) {
                alert("error1 data: " + data + " status: " + status);
            });

        };


        feqhiatService.shareFatwa = function (fatwa, social) {
            var bookName = utilServ.getBookNameByid(fatwa.bookid);


            var seperator = "----------";
            var shareText = fatwa.title +"\r\n"+ seperator +"\r\n"+ "كتاب : " + bookName+"\r\n" + seperator + "\r\n";
            for (var i = 0; i < fatwa.rais.length; i++) {
                shareText = shareText + fatwa.rais[i].marjaa + "\r\n" + fatwa.rais[i].rai +"\r\nالمصدر:"+ fatwa.rais[i].source +"\r\n"+ seperator;
            }
            shareText = shareText +"\r\n"+ "بواسطة تطبيق فقهيات" + "\r\n" + "للايفون والايباد" + "\r\n" + constants.shareappiosurl + "\r\n" +
            "للاندرويد" + "\r\n" + constants.shareappandroidurl;

            if (social == 'wa') {
                $cordovaSocialSharing
                    .shareViaWhatsApp(shareText)
                    .then(function (result) {
                        // Success!
                    }, function (err) {
                        // An error occurred. Show a message to the user
                    });
            }
            else if (social == 'fb') {
                $cordovaSocialSharing
                    .shareViaFacebook(shareText)
                    .then(function (result) {
                        // Success!
                    }, function (err) {
                        // An error occurred. Show a message to the user
                    });

            }
            else if (social == 'other') {
                $cordovaSocialSharing
                    .share(shareText)
                    .then(function (result) {
                        // Success!
                    }, function (err) {
                        // An error occurred. Show a message to the user
                    });

            }
            else {
                $cordovaClipboard
                    .copy(shareText)
                    .then(function () {
                        // success
                    }, function () {
                        // error
                    });

            }

        };


        feqhiatService.searchFatwas = function (scopeObj, callback, keyword, selectedMarjaa, selectedBook, selectedCat) {
            if (selectedMarjaa == -1) {
                selectedMarjaa = "all";
            }
            if (selectedBook == -1) {
                selectedBook = "all";
            }
            if (selectedCat == -1) {
                selectedCat = "all";
            }

            var searchurl = constants.searchurl + "?mid=" + selectedMarjaa + "&bookid=" + selectedBook + "&catid=" + selectedCat + "&keyword=" + keyword + "&time=" + Date.now();
            $http({
                method: "GET",
                url: searchurl
            }).success(function (data) {
                $rootScope.searchResults = data.fatwas;
                if (callback) {
                    callback();
                }
            }).error(function (data, status) {
                alert("error1 data: " + data + " status: " + status);
            });
        };

        feqhiatService.uploadIstifta = function (scopeObj, callback, name, email, istifta, selectedMarjaa) {
            if (name.trim().length < 1) {
                utilServ.showAlert("الاسم يجب ان لايكون خاليا");
                return;

            }

            if (email.trim().length < 1) {
                utilServ.showAlert("الايميل يجب ان لايكون خاليا");
                return;

            }

            if (utilServ.validateEmail(email) == false) {
                utilServ.showAlert("الرجاء ادخال الايميل بطريقة صحيحة");
                return;
            }


            if (istifta.trim().length < 1) {
                utilServ.showAlert("نص الاستفتاء يجب ان لايكون خاليا");
                return;
            }
            if (selectedMarjaa == -1) {
                selectedMarjaa = 99999;
            }
            $ionicLoading.show({
                template: 'الرجاء الانتظار'
            });

            var uploadistiftaurl=constants.uploadistiftaurl;
            var dataTosend={mid:selectedMarjaa,name:name,email:email,istifta:istifta};
            //  $http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";
            Object.toparams = function ObjecttoParams(obj) {
                var p = [];
                for (var key in obj) {
                    p.push(key + '=' + encodeURIComponent(obj[key]));
                }
                return p.join('&');
            };
            $http({
                method: 'POST',
                url:uploadistiftaurl,
                data:Object.toparams(dataTosend),
                headers: {'Content-Type': 'application/x-www-form-urlencoded'}
            }).then(function successCallback(data) {
                if(callback)
                {
                    callback();
                }
            }, function errorCallback(response) {
                alert("error1 response: " + response);
            });


        };

        return feqhiatService;
    });
