angular.module('starter.controllers', [])

    .controller('MainCtrl', function (constants, $scope, $ionicLoading, $rootScope,
                                      feqhiatService, $state, utilService, $localStorage) {
        // reset all rootScope variables
        $rootScope.itemID = '';
        $rootScope.bookID = '';
        $rootScope.chapterID = '';
        $rootScope.problemID = '';

        $ionicLoading.show({
            template: 'الرجاء الانتظار'
        });

        var successAllData = function () {
            // save the data to local storage and use it
            $localStorage['allData'] = $scope.allData;
            $scope.allItems =  $localStorage['allData'].items;//$scope.allData.items;
            $ionicLoading.hide();
        };

        var successAllParam = function () {
            $ionicLoading.hide();
            // if version is different force to update
            //alert($localStorage['al_params']);
            if(constants.app_version != utilService.getParamByName("app_version", $scope.al_params).value)
            {
                /// show the update page
                console.log("update");
            }
            // if params not saved before
            else if($localStorage['al_params'] ==  undefined)
            {
                // save it to local storage
                console.log("update DB");
                //console.log(utilService.getParamByName("db_version", $localStorage['al_params']));
                $localStorage['al_params'] = $scope.al_params;
                feqhiatService.getAllData($scope, successAllData);
            }
            else if(utilService.getParamByName("db_version", $localStorage['al_params']).value != utilService.getParamByName("db_version", $scope.al_params).value)
            {
                console.log("update DB 2");
                console.log(utilService.getParamByName("db_version", $localStorage['al_params']));
                $localStorage['al_params'] = $scope.al_params;
                feqhiatService.getAllData($scope, successAllData);
            }
            // check if db version is the same in both server and local
            else //if($window.localStorage['al_params'].db_version == $scope.al_params.db_version)
            {
                $scope.allItems =  $localStorage['allData'].items;//$scope.allData.items;
                $ionicLoading.hide();
            }
            // if not the same, get all data
            //else
            //{
            //    feqhiatService.getAllData($scope, successAllData);
            //}

            // else use the local one
        };

        feqhiatService.getAllParam($scope, successAllParam);

        $scope.navigateToView = function (itemID)
        {
            $rootScope.itemID = itemID;
            $state.go('tab.books');
        };
    })

    .controller('BookCtrl',
        function ($scope, feqhiatService, $state, utilService, $localStorage, $rootScope) {
            //$rootScope.itemID = '';
            $rootScope.bookID = '';
            $rootScope.chapterID = '';
            $rootScope.problemID = '';
            $scope.allBooks =  $localStorage.allData.books;

            $scope.navigateToView = function (bookID)
            {
                $rootScope.bookID = bookID;
                $state.go('tab.chapters');
            };
        }

    )

    .controller('ChapterCtrl',
    function ($scope, feqhiatService, $state, utilService, $localStorage, $rootScope) {
        /*$rootScope.itemID = '';
        $rootScope.bookID = '';*/
        $rootScope.chapterID = '';
        $rootScope.problemID = '';
        $scope.chapters =  utilService.getBookChapters($rootScope.bookID, $localStorage.allData.chapters);

        $scope.navigateToView = function (chapterID)
        {
            $rootScope.chapterID = chapterID;
            $state.go('tab.problem_list');
        };
    }

)

    .controller('ProblemListCtrl',
    function ($scope, feqhiatService, $state, utilService, $localStorage, $rootScope, $ionicLoading) {

        $rootScope.problemID = '';
        var successProblemList = function () {
            $scope.problem_list =  $scope.allData.data;//$scope.allData.items;
            $ionicLoading.hide();
        };

        feqhiatService.getProblemList($rootScope, $scope, successProblemList);
        $scope.navigateToView = function (problemID)
        {
            $rootScope.problemID = problemID;
            $state.go('tab.singleProblem');
        };
    }

)

    .controller('ProblemCtrl',
    function ($scope, feqhiatService, $state, utilService, $localStorage, $rootScope, $ionicLoading) {
        var successProblemSolutions = function () {
            $scope.solutions =  $scope.allData.data;//$scope.allData.items;
            $ionicLoading.hide();
        };

        feqhiatService.getProblemSolutions($rootScope, $scope, successProblemSolutions);

    }

)

  .controller('SendCtrl',
    function ($scope, feqhiatService, $state, utilService, $localStorage, $rootScope, $ionicLoading) {
        $scope.faqih_list = $localStorage['allData'].faqih;
        $scope.books = $localStorage['allData'].books;
        $scope.getChapters = function(bookID) {
            //console.log(bookID);
            $scope.chapters = utilService.getBookChapters(bookID, $localStorage['allData'].chapters);
        };

        var successSend = function () {
            $ionicLoading.hide();
            alert("تم إرسال الإستفتاء وسيتم الرد عليك في أقرب وقت");
        };

        $scope.sendFatwa = function (problem) {
            //console.log(problem);
            feqhiatService.sendFatwa($scope, successSend, problem)
        };

        //console.log($localStorage['allData']);
    }

)

  .controller('RecentCtrl', function($scope) {})

  .controller('SearchCtrl', function($scope, Chats) {
  // With the new view caching in Ionic, Controllers are only called
  // when they are recreated or on app start, instead of every page change.
  // To listen for when this page is active (for example, to refresh data),
  // listen for the $ionicView.enter event:
  //
  //$scope.$on('$ionicView.enter', function(e) {
  //});

  $scope.chats = Chats.all();
  $scope.remove = function(chat) {
    Chats.remove(chat);
  };
})

  .controller('AboutCtrl', function($scope) {
    $scope.settings = {
      enableFriends: true
    };
  })

  .controller('ChatDetailCtrl', function($scope, $stateParams, Chats) {
  $scope.chat = Chats.get($stateParams.chatId);
});
