/* 'use strict'; */

var MYTIMEOUT = 12000;

var DEFAULT_SIZE = 5000000; // max to avoid popup in safari/ios

var isWP8 = /IEMobile/.test(navigator.userAgent); // Matches WP(7/8/8.1)
var isWindows = /Windows /.test(navigator.userAgent); // Windows
var isAndroid = !isWindows && /Android/.test(navigator.userAgent);
var isMac = /Macintosh/.test(navigator.userAgent);
var isWKWebView = !isWindows && !isAndroid && !isWP8 && !isMac && !!window.webkit && !!window.webkit.messageHandlers;

// NOTE: In the core-master branch there is no difference between the default
// implementation and implementation #2. But the test will also apply
// the androidLockWorkaround: 1 option in the case of implementation #2.
var scenarioList = [
  isAndroid ? 'Plugin-implementation-default' : 'Plugin',
  'HTML5',
  'Plugin-implementation-2'
];

var scenarioCount = (!!window.hasWebKitBrowser) ? (isAndroid ? 3 : 2) : 1;

var mytests = function() {

  for (var i=0; i<scenarioCount; ++i) {

    describe(scenarioList[i] + ': tx sql select value results test(s)', function() {
      var scenarioName = scenarioList[i];
      var suiteName = scenarioName + ': ';
      var isWebSql = (i === 1);
      var isImpl2 = (i === 2);

      // NOTE: MUST be defined in function scope, NOT outer scope:
      var openDatabase = function(name, ignored1, ignored2, ignored3) {
        if (isImpl2) {
          return window.sqlitePlugin.openDatabase({
            // prevent reuse of database from default db implementation:
            name: 'i2-'+name,
            androidDatabaseImplementation: 2,
            androidLockWorkaround: 1,
            location: 1
          });
        }
        if (isWebSql) {
          return window.openDatabase(name, '1.0', 'Test', DEFAULT_SIZE);
        } else {
          return window.sqlitePlugin.openDatabase({name: name, location: 0});
        }
      }

      it(suiteName + 'US-ASCII String manipulation results test',
        function(done) {
          var db = openDatabase('ASCII-string-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          expect(db).toBeDefined();

          db.transaction(function(tx) {

            expect(tx).toBeDefined();

            tx.executeSql("SELECT UPPER('Some US-ASCII text') AS uppertext", [], function(tx, res) {
              console.log('res.rows.item(0).uppertext: ' + res.rows.item(0).uppertext);
              expect(res.rows.item(0).uppertext).toEqual('SOME US-ASCII TEXT');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });
          });
        }, MYTIMEOUT);

      // NOTE: This test is ONLY for the following Android scenarios:
      // 1. Web SQL test (Android 5.x/+)
      // 2. Cordova-sqlcipher-adapter version of this plugin
      if (isAndroid)
        it(suiteName + 'Android ICU-UNICODE string manipulation test', function(done) {
          if (isWebSql && /Android [1-4]/.test(navigator.userAgent)) pending('SKIP for Android versions 1.x-4.x Web SQL');
          if (!isWebSql) pending('SKIP for plugin');

          var db = openDatabase('ICU-UNICODE-string-manipulation-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          expect(db).toBeDefined();

          db.transaction(function(tx) {

            expect(tx).toBeDefined();

            // 'Some Cyrillic text'
            tx.executeSql("SELECT UPPER('Какой-то кириллический текст') AS uppertext", [], function (tx, res) {
              console.log('res.rows.item(0).uppertext: ' + res.rows.item(0).uppertext);
              expect(res.rows.item(0).uppertext).toEqual('КАКОЙ-ТО КИРИЛЛИЧЕСКИЙ ТЕКСТ');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });
          });
        });

        // Truthy string
        // ref: https://developer.mozilla.org/en-US/docs/Glossary/Truthy
        it(suiteName + 'SELECT TYPEOF(?) with ["abc"] parameter argument', function(done) {
          var db = openDatabase('SELECT-TYPEOF-with-abc-TEXT-string-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [null], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('null');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        // Falsy string
        // ref: https://developer.mozilla.org/en-US/docs/Glossary/Falsy

        it(suiteName + "SELECT TYPEOF('') (INLINE empty string) parameter argument", function(done) {
          var db = openDatabase('SELECT-TYPEOF-with-inline-empty-TEXT-string-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql("SELECT TYPEOF('') as myresult", null, function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe('text');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + "SELECT UPPER('') (INLINE empty string) parameter argument", function(done) {
          var db = openDatabase('SELECT-UPPER-with-inline-empty-TEXT-string-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql("SELECT UPPER('') as myresult", null, function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe('');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + "SELECT '' (INLINE empty string) parameter argument", function(done) {
          var db = openDatabase('SELECT-UPPER-with-inline-empty-TEXT-string-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql("SELECT '' as myresult", null, function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe('');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        // TBD for some reason on Android plugin with androidDatabaseImplementation:2 setting
        // TYPEOF returns text

        it(suiteName + 'SELECT TYPEOF(?) with [null] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-with-null-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [null], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('null');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [null] parameter argument [returns text in case of androidDatabaseImplementation: 2; BROKEN for Windows]', function(done) {
          var db = openDatabase('SELECT-with-null-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [null], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('');
              else
                expect(rs.rows.item(0).myresult).toBe(null);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [undefined] parameter argument [returns text in case of Android (WebKit) Web SQL or androidDatabaseImplementation: 2; BROKEN for Windows]', function(done) {
          if (isWP8) pending('SKIP for WP8'); // SKIP for now

          var db = openDatabase('SELECT-TYPEOF-with-undefined-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [undefined], function(ignored, rs) {
              if (isWindows) expect('Windows plugin version FIXED please update this test').toBe('--');
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if ((isWebSql && isAndroid) || (!isWebSql && isAndroid && isImpl2))
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('null');
              done();
            });
          }, function(error) {
            // ERROR in case of Windows:
            if (isWindows) {
              expect(error).toBeDefined();
              expect(error.code).toBeDefined();
              expect(error.message).toBeDefined();
              expect(error.code).toBe(0);
              expect(error.message).toMatch(/a statement with no error handler failed: Unsupported argument type: undefined/);
              return done();
            }

            // OTHERWISE
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [undefined] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          if (isWP8) pending('SKIP for WP8'); // SKIP for now

          var db = openDatabase('SELECT-with-undefined-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [undefined], function(ignored, rs) {
              if (isWindows) expect('Windows plugin version FIXED please update this test').toBe('--');
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (isWebSql && isAndroid)
                expect(rs.rows.item(0).myresult).toBe('undefined');
              else if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('');
              else
                expect(rs.rows.item(0).myresult).toBe(null);
              done();
            });
          }, function(error) {
            // ERROR in case of Windows:
            if (isWindows) {
              expect(error).toBeDefined();
              expect(error.code).toBeDefined();
              expect(error.message).toBeDefined();
              expect(error.code).toBe(0);
              expect(error.message).toMatch(/a statement with no error handler failed: Unsupported argument type: undefined/);
              return done();
            }

            // OTHERWISE
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        // Truthy number values
        // ref: https://developer.mozilla.org/en-US/docs/Glossary/Truthy

        // TBD for some reason Android/iOS WebKit Web SQL implementation returns
        // TYPEOF(?) with integer parameter arg value as 'real'
        // though it DOES apparently handle integer parameter arg value as
        // an integer.

        it(suiteName + 'SELECT TYPEOF(101) INLINE', function(done) {
          var db = openDatabase('SELECT-TYPEOF-101-inline.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(101) as myresult', [], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe('integer');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(101) INLINE', function(done) {
          var db = openDatabase('SELECT-ABS-101-inline.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(101) as myresult', [], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(101);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT 101 INLINE', function(done) {
          var db = openDatabase('SELECT-minus-101-inline.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT 101 as myresult', [], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(101);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(-101) INLINE', function(done) {
          var db = openDatabase('SELECT-TYPEOF-minus-101-inline.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(-101) as myresult', [], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe('integer');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(-101) INLINE', function(done) {
          var db = openDatabase('SELECT-ABS-minus-101-inline.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(-101) as myresult', [], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(101);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT -101 INLINE', function(done) {
          var db = openDatabase('SELECT-minus-101-inline.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT -101 as myresult', [], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(-101);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [101] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-with-101-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [101], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (isWebSql || isMac || isWKWebView)
                expect(rs.rows.item(0).myresult).toBe('real');
              else if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('integer');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(?) with [101] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-ABS-with-101-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(?) as myresult', [101], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(101);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [101] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-with-101-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [101], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('101');
              else
                expect(rs.rows.item(0).myresult).toBe(101);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [-101] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-with-minus-101-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [-101], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (isWebSql || isMac || isWKWebView)
                expect(rs.rows.item(0).myresult).toBe('real');
              else if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('integer');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(?) with [-101] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-ABS-with-minus-101-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(?) as myresult', [-101], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(101);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [-101] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-with-minus-101-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [-101], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('-101');
              else
                expect(rs.rows.item(0).myresult).toBe(-101);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [123.456] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-123.456.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [123.456], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('real');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(?) with [123.456] parameter argument', function(done) {
          var db = openDatabase('SELECT-ABS-123.456.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(?) as myresult', [123.456], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(123.456);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [123.456] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-123.456.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [123.456], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('123.456');
              else
                expect(rs.rows.item(0).myresult).toBe(123.456);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [-123.456] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-minus-123.456.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [-123.456], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('real');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(?) with [-123.456] parameter argument', function(done) {
          var db = openDatabase('SELECT-ABS-minus-123.456.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(?) as myresult', [-123.456], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(123.456);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [-123.456] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-minus-123.456.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [-123.456], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('-123.456');
              else
                expect(rs.rows.item(0).myresult).toBe(-123.456);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [1234567890123] (BIG INTEGER) parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-1234567890123.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [1234567890123], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (isWebSql || isMac || isWKWebView)
                expect(rs.rows.item(0).myresult).toBe('real');
              else if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('integer');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(?) with [1234567890123] (BIG INTEGER) parameter argument', function(done) {
          var db = openDatabase('SELECT-ABS-with-1234567890123-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(?) as myresult', [1234567890123], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(1234567890123);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [1234567890123] (BIG INTEGER) parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-with-1234567890123-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [1234567890123], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('1234567890123');
              else
                expect(rs.rows.item(0).myresult).toBe(1234567890123);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [-1234567890123] (BIG INTEGER) parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-minus-1234567890123.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [-1234567890123], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (isWebSql || isMac || isWKWebView)
                expect(rs.rows.item(0).myresult).toBe('real');
              else if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('integer');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(?) with [-1234567890123] (BIG INTEGER) parameter argument', function(done) {
          var db = openDatabase('SELECT-ABS-with-minus-1234567890123-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(?) as myresult', [-1234567890123], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(1234567890123);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [-1234567890123] (BIG INTEGER) parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-with-minus-1234567890123-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [-1234567890123], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('-1234567890123');
              else
                expect(rs.rows.item(0).myresult).toBe(-1234567890123);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [1234567890123.4] (BIG REAL) parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-1234567890123.4.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [1234567890123.4], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('real');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(?) with [1234567890123.4] (BIG REAL) parameter argument', function(done) {
          var db = openDatabase('SELECT-ABS-1234567890123.4.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(?) as myresult', [1234567890123.4], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(1234567890123.4);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [1234567890123.4] (BIG REAL) parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-1234567890123.4.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [1234567890123.4], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('1.2345678901234E12');
              else
                expect(rs.rows.item(0).myresult).toBe(1234567890123.4);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [-1234567890123.4] (BIG REAL) parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-minus-1234567890123.4.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [-1234567890123.4], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('real');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(?) with [-1234567890123.4] (BIG REAL) parameter argument', function(done) {
          var db = openDatabase('SELECT-ABS-minus-1234567890123.4.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(?) as myresult', [-1234567890123.4], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(1234567890123.4);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [-1234567890123.4] (BIG REAL) parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-minus-1234567890123.4.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [-1234567890123.4], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('-1.2345678901234E12');
              else
                expect(rs.rows.item(0).myresult).toBe(-1234567890123.4);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        // Falsy number value
        // ref: https://developer.mozilla.org/en-US/docs/Glossary/Falsy

        it(suiteName + 'SELECT TYPEOF(?) with [0] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-with-0-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [0], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (isWebSql || isMac || isWKWebView)
                expect(rs.rows.item(0).myresult).toBe('real');
              else if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('integer');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(?) with [0] parameter argument', function(done) {
          var db = openDatabase('SELECT-ABS-with-0-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(?) as myresult', [0], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(0);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [0] parameter argument', function(done) {
          var db = openDatabase('SELECT-with-0-argument.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [0], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('0');
              else
                expect(rs.rows.item(0).myresult).toBe(0);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [0.0] parameter argument [returns text in case of androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-0.0.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT TYPEOF(?) as myresult', [0.0], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (isWebSql || isMac || isWKWebView)
                expect(rs.rows.item(0).myresult).toBe('real');
              else if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('integer');
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ABS(?) with [0.0] parameter argument', function(done) {
          var db = openDatabase('SELECT-ABS-0.0.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ABS(?) as myresult', [0.0], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe(0);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT ? with [0.0] parameter argument', function(done) {
          var db = openDatabase('SELECT-0.0.db');
          expect(db).toBeDefined();

          db.transaction(function(tx) {
            tx.executeSql('SELECT ? as myresult', [0.0], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('0');
              else
                expect(rs.rows.item(0).myresult).toBe(0);
              done();
            });
          }, function(error) {
            expect(false).toBe(true);
            expect(error.message).toBe('--');
            done();
          });
        }, MYTIMEOUT);

      describe(suiteName + 'Infinity/NaN value test(s)', function() {

        // Android/iOS plugin BROKEN:
        // - CRASH on iOS as reported in litehelpers/Cordova-sqlite-storage#405
        // - Android version returns result with missing row
        it(suiteName + "SELECT ABS(?) with '9e999' (Infinity) parameter argument" +
           ((!isWebSql && isAndroid) ? ' [Android PLUGIN BROKEN: result with missing row]' : ''), function(done) {
          if (isWP8) pending('SKIP for WP8'); // (no callback received)
          if (!isWebSql && !isAndroid && !isWindows && !isWP8) pending('SKIP for iOS/macOS plugin due to CRASH');

          var db = openDatabase('SELECT-ABS-Infinite-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT ABS(?) AS myresult', ['9e999'], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();

              if (!isWebSql && !isWindows && isAndroid)
                expect(rs.rows.length).toBe(0);
              else
                expect(rs.rows.length).toBe(1);

              if (isWebSql || isWindows || isMac)
                expect(rs.rows.item(0).myresult).toBe(Infinity);

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + "SELECT -ABS(?) with '9e999' (Infinity) parameter argument" +
           ((!isWebSql && isAndroid) ? ' [Android PLUGIN BROKEN: missing result]' : ''), function(done) {
          if (isWP8) pending('SKIP for WP8'); // (no callback received)
          if (!isWebSql && !isAndroid && !isWindows && !isWP8) pending('SKIP for iOS/macOS plugin due to CRASH');

          var db = openDatabase('SELECT-ABS-minus-Infinite-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT -ABS(?) AS myresult', ['9e999'], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();

              if (!isWebSql && !isWindows && isAndroid)
                expect(rs.rows.length).toBe(0);
              else
                expect(rs.rows.length).toBe(1);

              if (isWebSql || isWindows || isMac)
                expect(rs.rows.item(0).myresult).toBe(-Infinity);

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + "SELECT UPPER(ABS(?)) with ['9e999'] (Infinity) parameter argument (reference test)", function(done) {
          var db = openDatabase('SELECT-UPPER-ABS-Infinite-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT UPPER(ABS(?)) AS myresult', ['9e999'], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();
              expect(rs.rows.item(0).myresult).toBe('INF');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + "SELECT LOWER(-ABS(?)) with ['9e999'] (Infinity) parameter argument (reference test)", function(done) {
          var db = openDatabase('SELECT-LOWER-minus-ABS-Infinite-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT LOWER(-ABS(?)) AS myresult', ['9e999'], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();
              expect(rs.rows.item(0).myresult).toBe('-inf');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT LOWER(?) with [Infinity] parameter argument [Android/iOS Plugin BROKEN: result with null value]', function(done) {
          if (isWP8) pending('SKIP for WP8'); // SKIP for now

          var db = openDatabase('SELECT-LOWER-Infinite-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT LOWER(?) AS myresult', [Infinity], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('');
              else if (!isWebSql && !isWindows && !isMac)
                expect(rs.rows.item(0).myresult).toBe(null);
              else
                expect(rs.rows.item(0).myresult).toBe('inf');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT UPPER(?) with [-Infinity] parameter argument [Android/iOS Plugin BROKEN: result with null value]', function(done) {
          if (isWP8) pending('SKIP for WP8'); // SKIP for now

          var db = openDatabase('SELECT-UPPER-minus-Infinite-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT UPPER(?) AS myresult', [-Infinity], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('');
              else if (!isWebSql && !isWindows && !isMac)
                expect(rs.rows.item(0).myresult).toBe(null);
              else
                expect(rs.rows.item(0).myresult).toBe('-INF');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with [Infinity] parameter argument [Android/iOS Plugin BROKEN: reports null type]', function(done) {
          if (isWP8) pending('SKIP for WP8'); // SKIP for now

          var db = openDatabase('SELECT-TYPEOF-Infinite-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT TYPEOF(?) AS myresult', [Infinity], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else if (!isWebSql && !isWindows && !isMac)
                expect(rs.rows.item(0).myresult).toBe('null');
              else
                expect(rs.rows.item(0).myresult).toBe('real');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with -Infinity parameter argument [Android/iOS Plugin BROKEN: reports null type]', function(done) {
          if (isWP8) pending('SKIP for WP8'); // SKIP for now

          var db = openDatabase('SELECT-TYPEOF-minus-Infinite-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT TYPEOF(?) AS myresult', [-Infinity], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else if (!isWebSql && !isWindows && !isMac)
                expect(rs.rows.item(0).myresult).toBe('null');
              else
                expect(rs.rows.item(0).myresult).toBe('real');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT (?) with Infinity parameter argument [Android/iOS Plugin BROKEN: result with null value; CRASH on macOS]', function(done) {
          if (isWP8) pending('SKIP for WP8'); // SKIP for now
          if (isMac) pending('SKIP for macOS [CRASH]'); // FUTURE TBD

          var db = openDatabase('SELECT-Infinite-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT (?) AS myresult', [Infinity], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('');
              else if (!isWebSql && !isWindows)
                expect(rs.rows.item(0).myresult).toBe(null);
              else
                expect(rs.rows.item(0).myresult).toBe(Infinity);

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT (?) with -Infinity parameter argument [Android/iOS Plugin BROKEN: result with null value; CRASH on macOS]', function(done) {
          if (isWP8) pending('SKIP for WP8'); // SKIP for now
          if (isMac) pending('SKIP for macOS [CRASH]'); // FUTURE TBD

          var db = openDatabase('SELECT-minus-Infinite-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT (?) AS myresult', [-Infinity], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('');
              else if (!isWebSql && !isWindows)
                expect(rs.rows.item(0).myresult).toBe(null);
              else
                expect(rs.rows.item(0).myresult).toBe(-Infinity);

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        // General ref: http://sqlite.1065341.n5.nabble.com/NaN-in-0-0-out-td19086.html

        it(suiteName + "Infinity/NaN reference test: SELECT ABS(?)-ABS(?) with '9e999' (Infinity) parameter argument values", function(done) {
          var db = openDatabase('SELECT-ABS-minus-ABS-with-Infinite-parameter-values-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT ABS(?)-ABS(?) AS myresult', ['9e999', '9e999'], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();

              expect(rs.rows.item(0).myresult).toBe(null);

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'Infinity/NaN test: SELECT (?-?) with Infinity parameter argument values [Infinity/NaN ISSUE with androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-minus-with-Infinite-parameter-values-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT (?-?) AS myresult', [Infinity, Infinity], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe(0);
              else
                expect(rs.rows.item(0).myresult).toBe(null);

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'Infinity/NaN test: SELECT (?+?) with [Infinity, -Infinity] parameter argument values [Infinity/NaN ISSUE with androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-sum-with-Infinite-and-minus-Infinity-parameter-values-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT (?+?) AS myresult', [Infinity, -Infinity], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe(0);
              else
                expect(rs.rows.item(0).myresult).toBe(null);

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + "NaN reference test: SELECT (1/0)", function(done) {
          var db = openDatabase('SELECT-1-div-0-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT (1/0) AS myresult', [], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();
              expect(rs.rows.item(0).myresult).toBe(null);

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT UPPER(?) with NaN parameter argument value [Infinity/NaN ISSUE with androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-UPPER-with-NaN-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT UPPER(?) AS myresult', [NaN], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('');
              else
                expect(rs.rows.item(0).myresult).toBe(null);

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT TYPEOF(?) with NaN parameter argument value [Infinity/NaN ISSUE with androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-TYPEOF-with-NaN-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT TYPEOF(?) AS myresult', [NaN], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('text');
              else
                expect(rs.rows.item(0).myresult).toBe('null');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + 'SELECT (?) with NaN parameter argument value [Infinity/NaN ISSUE with androidDatabaseImplementation: 2]', function(done) {
          var db = openDatabase('SELECT-NaN-parameter-results-test.db', '1.0', 'Test', DEFAULT_SIZE);

          db.transaction(function(tx) {
            expect(tx).toBeDefined();

            tx.executeSql('SELECT (?) AS myresult', [NaN], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBeDefined();

              // Android/iOS plugin issue
              if (!isWebSql && isAndroid && isImpl2)
                expect(rs.rows.item(0).myresult).toBe('');
              else
                expect(rs.rows.item(0).myresult).toBe(null);

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

      });

        it(suiteName + 'String test with array parameter value including undefined/Infinity/NaN values', function(done) {
          var db = openDatabase("String-test-with-array-parameter-value.db", "1.0", "Demo", DEFAULT_SIZE);

          db.transaction(function(tx) {

            tx.executeSql('SELECT UPPER(?) AS upper_result', [['a',undefined,'b',Infinity,'c',-Infinity,'d',NaN,'e']], function(ignored, rs) {
              expect(rs.rows.item(0).upper_result).toBe('A,,B,INFINITY,C,-INFINITY,D,NAN,E');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });
          });
        }, MYTIMEOUT);

      describe(suiteName + 'Inline BLOB value SELECT result tests', function() {

        it(suiteName + "SELECT LOWER(X'40414243')", function(done) {
          if (isWindows) pending('SKIP: BROKEN for Windows');

          var db = openDatabase("Inline-BLOB-lower-result-test.db", "1.0", "Demo", DEFAULT_SIZE);

          db.transaction(function(tx) {

            tx.executeSql("SELECT LOWER(X'40414243') AS myresult", [], function(ignored, rs) {
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe('@abc');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });
          }, function(error) {
            // NOT EXPECTED:
            expect(false).toBe(true);
            expect(error.message).toBe('---');
            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + "SELECT X'40414243'", function(done) {
          if (isWP8) pending('SKIP for WP8'); // [BROKEN]
          if (!isWebSql && isAndroid && isImpl2) pending('SKIP: BROKEN for androidDatabaseImplementation: 2');
          if (isWindows) pending('SKIP: BROKEN for Windows');

          var db = openDatabase("Inline-BLOB-SELECT-result-40414243-test.db", "1.0", "Demo", DEFAULT_SIZE);

          db.transaction(function(tx) {

            tx.executeSql("SELECT X'40414243' AS myresult", [], function(ignored, rs) {
              if (!isWebSql && isAndroid && isImpl2) expect('Behavior changed please update this test').toBe('--');
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              expect(rs.rows.item(0).myresult).toBe('@ABC');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            }, function(ignored, error) {
              // NOT EXPECTED:
              expect(false).toBe(true);
              expect(error.message).toBe('---');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            if (!isWebSql && isAndroid && isImpl2) {
              expect(error).toBeDefined();
              expect(error.code).toBeDefined();
              expect(error.message).toBeDefined();

              // TBD wrong error code
              expect(error.code).toBe(0);
              expect(error.message).toMatch(/error callback did not return false: unknown error.*code 0.*Unable to convert BLOB to string/);
            } else {
              // NOT EXPECTED:
              expect(false).toBe(true);
              expect(error.message).toBe('---');
            }

            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

        it(suiteName + "SELECT X'FFD1FFD2' [Plugin BROKEN: missing result column data]", function(done) {
          if (isWP8) pending('SKIP for WP8'); // [BROKEN]
          if (!isWebSql && isAndroid && !isImpl2) pending('SKIP for default Android implemetation [POSSIBLE CRASH]');
          if (!isWebSql && isAndroid && isImpl2) pending('SKIP: BROKEN for androidDatabaseImplementation: 2');
          if (isWindows) pending('SKIP: BROKEN for Windows');

          var db = openDatabase("Inline-BLOB-SELECT-result-FFD1FFD2-test.db", "1.0", "Demo", DEFAULT_SIZE);

          db.transaction(function(tx) {

            tx.executeSql("SELECT X'FFD1FFD2' AS myresult", [], function(ignored, rs) {
              if (!isWebSql && isAndroid && isImpl2) expect('Behavior changed please update this test').toBe('--');
              expect(rs).toBeDefined();
              expect(rs.rows).toBeDefined();
              expect(rs.rows.length).toBe(1);
              var item = rs.rows.item(0);
              expect(item).toBeDefined();

              var myresult = item.myresult;

              if (!isWebSql) {
                // PLUGIN (iOS/macOS):
                expect(myresult).not.toBeDefined();
                return done();
              } else {
                expect(myresult).toBeDefined();
                expect(myresult.length).toBe(4);
              }

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            }, function(ignored, error) {
              // NOT EXPECTED:
              expect(false).toBe(true);
              expect(error.message).toBe('---');

              // Close (plugin only) & finish:
              (isWebSql) ? done() : db.close(done, done);
            });

          }, function(error) {
            if (!isWebSql && isAndroid && isImpl2) {
              expect(error).toBeDefined();
              expect(error.code).toBeDefined();
              expect(error.message).toBeDefined();

              // TBD wrong error code
              expect(error.code).toBe(0);
              expect(error.message).toMatch(/error callback did not return false: unknown error.*code 0.*Unable to convert BLOB to string/);
            } else {
              // NOT EXPECTED:
              expect(false).toBe(true);
              expect(error.message).toBe('---');
            }

            // Close (plugin only) & finish:
            (isWebSql) ? done() : db.close(done, done);
          });
        }, MYTIMEOUT);

      });

    });

  }

}

if (window.hasBrowser) mytests();
else exports.defineAutoTests = mytests;

/* vim: set expandtab : */
