"use strict";
var config_1 = require('./util/config');
var helpers_1 = require('./util/helpers');
var logger_1 = require('./logger/logger');
var watch_1 = require('./watch');
var open_1 = require('./util/open');
var notification_server_1 = require('./dev-server/notification-server');
var http_server_1 = require('./dev-server/http-server');
var live_reload_1 = require('./dev-server/live-reload');
var serve_config_1 = require('./dev-server/serve-config');
var DEV_LOGGER_DEFAULT_PORT = 53703;
var LIVE_RELOAD_DEFAULT_PORT = 35729;
var DEV_SERVER_DEFAULT_PORT = 8100;
var DEV_SERVER_DEFAULT_HOST = '0.0.0.0';
function serve(context) {
    helpers_1.setContext(context);
    var config = {
        httpPort: getHttpServerPort(context),
        host: getHttpServerHost(context),
        rootDir: context.rootDir,
        wwwDir: context.wwwDir,
        buildDir: context.buildDir,
        isCordovaServe: isCordovaServe(context),
        launchBrowser: launchBrowser(context),
        launchLab: launchLab(context),
        browserToLaunch: browserToLaunch(context),
        useLiveReload: useLiveReload(context),
        liveReloadPort: getLiveReloadServerPort(context),
        notificationPort: getNotificationPort(context),
        useServerLogs: useServerLogs(context),
        useProxy: useProxy(context),
        notifyOnConsoleLog: sendClientConsoleLogs(context)
    };
    notification_server_1.createNotificationServer(config);
    live_reload_1.createLiveReloadServer(config);
    http_server_1.createHttpServer(config);
    return watch_1.watch(context)
        .then(function () {
        onReady(config, context);
    }, function (err) {
        throw err;
    })
        .catch(function (err) {
        if (err && err.isFatal) {
            throw err;
        }
        else {
            onReady(config, context);
        }
    });
}
exports.serve = serve;
function onReady(config, context) {
    var host = config.host === '0.0.0.0' ? 'localhost' : config.host;
    if (config.launchBrowser || config.launchLab) {
        var openOptions = [("http://" + host + ":" + config.httpPort)]
            .concat(launchLab(context) ? [serve_config_1.IONIC_LAB_URL] : [])
            .concat(browserOption(context) ? [browserOption(context)] : [])
            .concat(platformOption(context) ? ['?ionicplatform=', platformOption(context)] : []);
        open_1.default(openOptions.join(''), browserToLaunch(context));
    }
    logger_1.Logger.info("dev server running: http://" + host + ":" + config.httpPort + "/", 'green', true);
    logger_1.Logger.newLine();
}
function getHttpServerPort(context) {
    var port = config_1.getConfigValue(context, '--port', '-p', 'IONIC_PORT', 'ionic_port', null);
    if (port) {
        return parseInt(port, 10);
    }
    return DEV_SERVER_DEFAULT_PORT;
}
function getHttpServerHost(context) {
    var host = config_1.getConfigValue(context, '--address', '-h', 'IONIC_ADDRESS', 'ionic_address', null);
    if (host) {
        return host;
    }
    return DEV_SERVER_DEFAULT_HOST;
}
function getLiveReloadServerPort(context) {
    var port = config_1.getConfigValue(context, '--livereload-port', null, 'IONIC_LIVERELOAD_PORT', 'ionic_livereload_port', null);
    if (port) {
        return parseInt(port, 10);
    }
    return LIVE_RELOAD_DEFAULT_PORT;
}
function getNotificationPort(context) {
    var port = config_1.getConfigValue(context, '--dev-logger-port', null, 'IONIC_DEV_LOGGER_PORT', 'ionic_dev_logger_port', null);
    if (port) {
        return parseInt(port, 10);
    }
    return DEV_LOGGER_DEFAULT_PORT;
}
exports.getNotificationPort = getNotificationPort;
function useServerLogs(context) {
    return config_1.hasConfigValue(context, '--serverlogs', '-s', 'ionic_serverlogs', false);
}
function isCordovaServe(context) {
    return config_1.hasConfigValue(context, '--iscordovaserve', '-z', 'ionic_cordova_serve', false);
}
function launchBrowser(context) {
    return !config_1.hasConfigValue(context, '--nobrowser', '-b', 'ionic_launch_browser', false);
}
function browserToLaunch(context) {
    return config_1.getConfigValue(context, '--browser', '-w', 'IONIC_BROWSER', 'ionic_browser', null);
}
function browserOption(context) {
    return config_1.getConfigValue(context, '--browseroption', '-o', 'IONIC_BROWSEROPTION', 'ionic_browseroption', null);
}
function launchLab(context) {
    return config_1.hasConfigValue(context, '--lab', '-l', 'ionic_lab', false);
}
function platformOption(context) {
    return config_1.getConfigValue(context, '--platform', '-t', 'IONIC_PLATFORM_BROWSER', 'ionic_platform_browser', null);
}
function useLiveReload(context) {
    return !config_1.hasConfigValue(context, '--nolivereload', '-d', 'ionic_livereload', false);
}
function useProxy(context) {
    return !config_1.hasConfigValue(context, '--noproxy', '-x', 'ionic_proxy', false);
}
function sendClientConsoleLogs(context) {
    return config_1.hasConfigValue(context, '--consolelogs', '-c', 'ionic_consolelogs', false);
}
