import { EventEmitter } from '@angular/core';
import { AppPortal, IonicApp } from './app-root';
import { ClickBlock } from '../../util/click-block';
import { Config } from '../../config/config';
import { NavOptions } from '../../navigation/nav-util';
import { NavController } from '../../navigation/nav-controller';
import { Platform } from '../../platform/platform';
import { ViewController } from '../../navigation/view-controller';
import { MenuController } from '../menu/menu-controller';
/**
 * @name App
 * @description
 * App is a utility class used in Ionic to get information about various aspects of an app
 */
export declare class App {
    private _config;
    private _platform;
    private _menuCtrl;
    private _disTime;
    private _scrollTime;
    private _title;
    private _titleSrv;
    private _rootNav;
    private _disableScrollAssist;
    /**
     * @private
     */
    _clickBlock: ClickBlock;
    /**
     * @private
     */
    _appRoot: IonicApp;
    /**
     * @private
     */
    viewDidLoad: EventEmitter<any>;
    /**
     * @private
     */
    viewWillEnter: EventEmitter<any>;
    /**
     * @private
     */
    viewDidEnter: EventEmitter<any>;
    /**
     * @private
     */
    viewWillLeave: EventEmitter<any>;
    /**
     * @private
     */
    viewDidLeave: EventEmitter<any>;
    /**
     * @private
     */
    viewWillUnload: EventEmitter<any>;
    constructor(_config: Config, _platform: Platform, _menuCtrl?: MenuController);
    /**
     * Sets the document title.
     * @param {string} val  Value to set the document title to.
     */
    setTitle(val: string): void;
    /**
     * @private
     */
    setElementClass(className: string, isAdd: boolean): void;
    /**
     * @private
     * Sets if the app is currently enabled or not, meaning if it's
     * available to accept new user commands. For example, this is set to `false`
     * while views transition, a modal slides up, an action-sheet
     * slides up, etc. After the transition completes it is set back to `true`.
     * @param {boolean} isEnabled `true` for enabled, `false` for disabled
     * @param {number} duration  When `isEnabled` is set to `false`, this argument
     * is used to set the maximum number of milliseconds that app will wait until
     * it will automatically enable the app again. It's basically a fallback incase
     * something goes wrong during a transition and the app wasn't re-enabled correctly.
     */
    setEnabled(isEnabled: boolean, duration?: number): void;
    /**
     * @private
     * Toggles whether an application can be scrolled
     * @param {boolean} disableScroll when set to `false`, the application's
     * scrolling is enabled. When set to `true`, scrolling is disabled.
     */
    _setDisableScroll(disableScroll: boolean): void;
    /**
     * @private
     * Boolean if the app is actively enabled or not.
     * @return {boolean}
     */
    isEnabled(): boolean;
    /**
     * @private
     */
    setScrolling(): void;
    /**
     * Boolean if the app is actively scrolling or not.
     * @return {boolean} returns true or false
     */
    isScrolling(): boolean;
    /**
     * @private
     */
    getActiveNav(): NavController;
    /**
     * @return {NavController} Returns the root NavController
     */
    getRootNav(): NavController;
    /**
     * @private
     */
    _setRootNav(nav: any): void;
    /**
     * @private
     */
    present(enteringView: ViewController, opts: NavOptions, appPortal?: AppPortal): Promise<any>;
    /**
     * @private
     */
    goBack(): Promise<any>;
    /**
     * @private
     */
    navPop(): Promise<any>;
}
