var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
(function (factory) {
    if (typeof module === 'object' && typeof module.exports === 'object') {
        var v = factory(require, exports); if (v !== undefined) module.exports = v;
    }
    else if (typeof define === 'function' && define.amd) {
        define(["require", "exports", '@angular/core', './action-sheet-component', '../app/app', '../../util/util', '../../navigation/view-controller'], factory);
    }
})(function (require, exports) {
    "use strict";
    var core_1 = require('@angular/core');
    var action_sheet_component_1 = require('./action-sheet-component');
    var app_1 = require('../app/app');
    var util_1 = require('../../util/util');
    var view_controller_1 = require('../../navigation/view-controller');
    /**
     * @private
     */
    var ActionSheet = (function (_super) {
        __extends(ActionSheet, _super);
        function ActionSheet(app, opts) {
            opts.buttons = opts.buttons || [];
            opts.enableBackdropDismiss = util_1.isPresent(opts.enableBackdropDismiss) ? !!opts.enableBackdropDismiss : true;
            _super.call(this, action_sheet_component_1.ActionSheetCmp, opts, null);
            this._app = app;
            this.isOverlay = true;
        }
        /**
         * @private
         */
        ActionSheet.prototype.getTransitionName = function (direction) {
            var key = 'actionSheet' + (direction === 'back' ? 'Leave' : 'Enter');
            return this._nav && this._nav.config.get(key);
        };
        /**
         * @param {string} title Action sheet title
         */
        ActionSheet.prototype.setTitle = function (title) {
            this.data.title = title;
        };
        /**
         * @param {string} subTitle Action sheet subtitle
         */
        ActionSheet.prototype.setSubTitle = function (subTitle) {
            this.data.subTitle = subTitle;
        };
        /**
         * @param {object} button Action sheet button
         */
        ActionSheet.prototype.addButton = function (button) {
            this.data.buttons.push(button);
        };
        /**
         * Present the action sheet instance.
         *
         * @param {NavOptions} [opts={}] Nav options to go with this transition.
         * @returns {Promise} Returns a promise which is resolved when the transition has completed.
         */
        ActionSheet.prototype.present = function (navOptions) {
            if (navOptions === void 0) { navOptions = {}; }
            return this._app.present(this, navOptions);
        };
        return ActionSheet;
    }(view_controller_1.ViewController));
    exports.ActionSheet = ActionSheet;
    /**
     * @name ActionSheetController
     * @description
     * An Action Sheet is a dialog that lets the user choose from a set of
     * options. It appears on top of the app's content, and must be manually
     * dismissed by the user before they can resume interaction with the app.
     * Dangerous (destructive) options are made obvious in `ios` mode. There are easy
     * ways to cancel out of the action sheet, such as tapping the backdrop or
     * hitting the escape key on desktop.
     *
     * An action sheet is created from an array of `buttons`, with each button
     * including properties for its `text`, and optionally a `handler` and `role`.
     * If a handler returns `false` then the action sheet will not be dismissed. An
     * action sheet can also optionally have a `title`, `subTitle` and an `icon`.
     *
     * A button's `role` property can either be `destructive` or `cancel`. Buttons
     * without a role property will have the default look for the platform. Buttons
     * with the `cancel` role will always load as the bottom button, no matter where
     * they are in the array. All other buttons will be displayed in the order they
     * have been added to the `buttons` array. Note: We recommend that `destructive`
     * buttons are always the first button in the array, making them the top button.
     * Additionally, if the action sheet is dismissed by tapping the backdrop, then
     * it will fire the handler from the button with the cancel role.
     *
     * You can pass all of the action sheet's options in the first argument of
     * the create method: `ActionSheet.create(opts)`. Otherwise the action sheet's
     * instance has methods to add options, like `setTitle()` or `addButton()`.
     *
     * @usage
     * ```ts
     * import { ActionSheetController } from 'ionic-angular'
     *
     * export class MyClass{
     *
     *  constructor(public actionSheetCtrl: ActionSheetController) {}
     *
     *  presentActionSheet() {
     *    let actionSheet = this.actionSheetCtrl.create({
     *      title: 'Modify your album',
     *      buttons: [
     *        {
     *          text: 'Destructive',
     *          role: 'destructive',
     *          handler: () => {
     *            console.log('Destructive clicked');
     *          }
     *        },
     *        {
     *          text: 'Archive',
     *          handler: () => {
     *            console.log('Archive clicked');
     *          }
     *        },
     *        {
     *          text: 'Cancel',
     *          role: 'cancel',
     *          handler: () => {
     *            console.log('Cancel clicked');
     *          }
     *        }
     *      ]
     *    });
     *
     *    actionSheet.present();
     *  }
     * }
     * ```
     *
     * @advanced
     *
     * ActionSheet create options
     *
     * | Option                | Type       | Description                                                        |
     * |-----------------------|------------|--------------------------------------------------------------------|
     * | title                 |`string`    | The title for the Action Sheet.                                    |
     * | subTitle              |`string`    | The sub-title for the Action Sheet.                                |
     * | cssClass              |`string`    | Additional classes for custom styles, separated by spaces.         |
     * | enableBackdropDismiss |`boolean`   | If the Action Sheet should close when the user taps the backdrop.  |
     * | buttons               |`array<any>`| An array of buttons to display.                                    |
     *
     * ActionSheet button options
     *
     * | Option   | Type     | Description                                                                                                                                      |
     * |----------|----------|--------------------------------------------------------------------------------------------------------------------------------------------------|
     * | text     | `string` | The buttons text.                                                                                                                                |
     * | icon     | `icon`   | The buttons icons.                                                                                                                               |
     * | handler  | `any`    | An express the button should evaluate.                                                                                                           |
     * | cssClass | `string` | Additional classes for custom styles, separated by spaces.                                                                                       |
     * | role     | `string` | How the button should be displayed, `destructive` or `cancel`. If not role is provided, it will display the button without any additional styles.|
     *
     *
     * ### Dismissing And Async Navigation
     *
     * After an action sheet has been dismissed, the app may need to also transition
     * to another page depending on the handler's logic. However, because multiple
     * transitions were fired at roughly the same time, it's difficult for the
     * nav controller to cleanly animate multiple transitions that may
     * have been kicked off asynchronously. This is further described in the
     * [`Nav Transition Promises`](../../nav/NavController/#nav-transition-promises) section. For action sheets,
     * this means it's best to wait for the action sheet to finish its transition
     * out before starting a new transition on the same nav controller.
     *
     * In the example below, after the button has been clicked, its handler
     * waits on async operation to complete, *then* it uses `pop` to navigate
     * back a page in the same stack. The potential problem is that the async operation
     * may have been completed before the action sheet has even finished its transition
     * out. In this case, it's best to ensure the action sheet has finished its transition
     * out first, *then* start the next transition.
     *
     * ```ts
     * let actionSheet = this.actionSheetCtrl.create({
     *   title: 'Hello',
     *   buttons: [{
     *     text: 'Ok',
     *     handler: () => {
     *       // user has clicked the action sheet button
     *       // begin the action sheet's dimiss transition
     *       let navTransition = actionSheet.dismiss();
     *
     *       // start some async method
     *       someAsyncOperation().then(() => {
     *         // once the async operation has completed
     *         // then run the next nav transition after the
     *         // first transition has finished animating out
     *
     *         navTransition.then(() => {
     *           this.nav.pop();
     *         });
     *       });
     *       return false;
     *     }
     *   }]
     * });
     *
     * actionSheet.present();
     * ```
     *
     * It's important to note that the handler returns `false`. A feature of
     * button handlers is that they automatically dismiss the action sheet when their button
     * was clicked, however, we'll need more control regarding the transition. Because
     * the handler returns `false`, then the action sheet does not automatically dismiss
     * itself. Instead, you now have complete control of when the action sheet has finished
     * transitioning, and the ability to wait for the action sheet to finish transitioning
     * out before starting a new transition.
     *
     *
     * @demo /docs/v2/demos/src/action-sheet/
     * @see {@link /docs/v2/components#action-sheets ActionSheet Component Docs}
     */
    var ActionSheetController = (function () {
        function ActionSheetController(_app) {
            this._app = _app;
        }
        /**
         * Open an action sheet with a title, subTitle, and an array of buttons
         * @param {ActionSheetOptions} opts Action sheet options
         */
        ActionSheetController.prototype.create = function (opts) {
            if (opts === void 0) { opts = {}; }
            return new ActionSheet(this._app, opts);
        };
        ActionSheetController.decorators = [
            { type: core_1.Injectable },
        ];
        /** @nocollapse */
        ActionSheetController.ctorParameters = [
            { type: app_1.App, },
        ];
        return ActionSheetController;
    }());
    exports.ActionSheetController = ActionSheetController;
});
//# sourceMappingURL=action-sheet.js.map