var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
(function (factory) {
    if (typeof module === 'object' && typeof module.exports === 'object') {
        var v = factory(require, exports); if (v !== undefined) module.exports = v;
    }
    else if (typeof define === 'function' && define.amd) {
        define(["require", "exports", '@angular/core', './app', '../../config/config', '../ion', '../nav/overlay-portal', '../../platform/platform', '../../util/dom'], factory);
    }
})(function (require, exports) {
    "use strict";
    var core_1 = require('@angular/core');
    var app_1 = require('./app');
    var config_1 = require('../../config/config');
    var ion_1 = require('../ion');
    var overlay_portal_1 = require('../nav/overlay-portal');
    var platform_1 = require('../../platform/platform');
    var dom_1 = require('../../util/dom');
    exports.AppRootToken = new core_1.OpaqueToken('USERROOT');
    /**
     * @private
     */
    var IonicApp = (function (_super) {
        __extends(IonicApp, _super);
        function IonicApp(_userCmp, _cfr, elementRef, renderer, config, _platform, app) {
            _super.call(this, config, elementRef, renderer);
            this._userCmp = _userCmp;
            this._cfr = _cfr;
            this._platform = _platform;
            // register with App that this is Ionic's appRoot component. tada!
            app._appRoot = this;
            this._stopScrollPlugin = window['IonicStopScroll'];
        }
        IonicApp.prototype.ngOnInit = function () {
            var _this = this;
            // load the user root component
            // into Ionic's root component
            var factory = this._cfr.resolveComponentFactory(this._userCmp);
            var componentRef = this._viewport.createComponent(factory);
            this._renderer.setElementClass(componentRef.location.nativeElement, 'app-root', true);
            componentRef.changeDetectorRef.detectChanges();
            // set the mode class name
            // ios/md/wp
            this.setElementClass(this._config.get('mode'), true);
            var versions = this._platform.versions();
            this._platform.platforms().forEach(function (platformName) {
                // platform-ios
                var platformClass = 'platform-' + platformName;
                _this.setElementClass(platformClass, true);
                var platformVersion = versions[platformName];
                if (platformVersion) {
                    // platform-ios9
                    platformClass += platformVersion.major;
                    _this.setElementClass(platformClass, true);
                    // platform-ios9_3
                    _this.setElementClass(platformClass + '_' + platformVersion.minor, true);
                }
            });
            // touch devices should not use :hover CSS pseudo
            // enable :hover CSS when the "hoverCSS" setting is not false
            if (this._config.getBoolean('hoverCSS', true)) {
                this.setElementClass('enable-hover', true);
            }
            // sweet, the app root has loaded!
            // which means angular and ionic has fully loaded!
            // fire off the platform prepare ready, which could
            // have been switched out by any of the platform engines
            this._platform.prepareReady();
        };
        /**
         * @private
         */
        IonicApp.prototype._getPortal = function (portal) {
            if (portal === 2 /* LOADING */) {
                return this._loadingPortal;
            }
            if (portal === 3 /* TOAST */) {
                return this._toastPortal;
            }
            // Modals need their own overlay becuase we don't want an ActionSheet
            // or Alert to trigger lifecycle events inside a modal
            if (portal === 1 /* MODAL */) {
                return this._modalPortal;
            }
            return this._overlayPortal;
        };
        /**
         * @private
         */
        IonicApp.prototype._getActivePortal = function () {
            var defaultPortal = this._overlayPortal;
            var modalPortal = this._modalPortal;
            var hasModal = modalPortal.length() > 0;
            var hasDefault = defaultPortal.length() > 0;
            if (!hasModal && !hasDefault) {
                return null;
            }
            else if (hasModal && hasDefault) {
                var defaultIndex = defaultPortal.getActive().getZIndex();
                var modalIndex = modalPortal.getActive().getZIndex();
                if (defaultIndex > modalIndex) {
                    return defaultPortal;
                }
                else {
                    (void 0) /* assert */;
                    return modalPortal;
                }
            }
            if (hasModal) {
                return modalPortal;
            }
            else if (hasDefault) {
                return defaultPortal;
            }
        };
        /**
         * @private
         */
        IonicApp.prototype._disableScroll = function (shouldDisableScroll) {
            var _this = this;
            if (shouldDisableScroll) {
                this.stopScroll().then(function () {
                    _this._rafId = dom_1.nativeTimeout(function () {
                        (void 0) /* console.debug */;
                        _this.setElementClass('disable-scroll', true);
                    }, 16 * 2);
                });
            }
            else {
                var plugin = this._stopScrollPlugin;
                if (plugin && plugin.cancel) {
                    plugin.cancel();
                }
                clearTimeout(this._rafId);
                (void 0) /* console.debug */;
                this.setElementClass('disable-scroll', false);
            }
        };
        IonicApp.prototype.stopScroll = function () {
            var _this = this;
            if (this._stopScrollPlugin) {
                return new Promise(function (resolve, reject) {
                    _this._stopScrollPlugin.stop(function () { return resolve(true); });
                });
            }
            else {
                return Promise.resolve(false);
            }
        };
        IonicApp.decorators = [
            { type: core_1.Component, args: [{
                        selector: 'ion-app',
                        template: '<div #viewport app-viewport></div>' +
                            '<div #modalPortal overlay-portal></div>' +
                            '<div #overlayPortal overlay-portal></div>' +
                            '<div #loadingPortal class="loading-portal" overlay-portal></div>' +
                            '<div #toastPortal class="toast-portal" [overlay-portal]="10000"></div>' +
                            '<div class="click-block"></div>'
                    },] },
        ];
        /** @nocollapse */
        IonicApp.ctorParameters = [
            { type: undefined, decorators: [{ type: core_1.Inject, args: [exports.AppRootToken,] },] },
            { type: core_1.ComponentFactoryResolver, },
            { type: core_1.ElementRef, },
            { type: core_1.Renderer, },
            { type: config_1.Config, },
            { type: platform_1.Platform, },
            { type: app_1.App, },
        ];
        IonicApp.propDecorators = {
            '_viewport': [{ type: core_1.ViewChild, args: ['viewport', { read: core_1.ViewContainerRef },] },],
            '_modalPortal': [{ type: core_1.ViewChild, args: ['modalPortal', { read: overlay_portal_1.OverlayPortal },] },],
            '_overlayPortal': [{ type: core_1.ViewChild, args: ['overlayPortal', { read: overlay_portal_1.OverlayPortal },] },],
            '_loadingPortal': [{ type: core_1.ViewChild, args: ['loadingPortal', { read: overlay_portal_1.OverlayPortal },] },],
            '_toastPortal': [{ type: core_1.ViewChild, args: ['toastPortal', { read: overlay_portal_1.OverlayPortal },] },],
        };
        return IonicApp;
    }(ion_1.Ion));
    exports.IonicApp = IonicApp;
    ;
});
//# sourceMappingURL=app-root.js.map