(function (factory) {
    if (typeof module === 'object' && typeof module.exports === 'object') {
        var v = factory(require, exports); if (v !== undefined) module.exports = v;
    }
    else if (typeof define === 'function' && define.amd) {
        define(["require", "exports", '@angular/core', '../button/button', './menu-controller', '../navbar/navbar', '../../navigation/view-controller'], factory);
    }
})(function (require, exports) {
    "use strict";
    var core_1 = require('@angular/core');
    var button_1 = require('../button/button');
    var menu_controller_1 = require('./menu-controller');
    var navbar_1 = require('../navbar/navbar');
    var view_controller_1 = require('../../navigation/view-controller');
    /**
     * @name MenuToggle
     * @description
     * The `menuToggle` directive can be placed on any button to toggle a menu open or closed.
     * If it is added to the [NavBar](../../nav/NavBar) of a page, the button will only appear
     * when the page it's in is currently a root page. See the [Menu Navigation Bar Behavior](../Menu#navigation-bar-behavior)
     * docs for more information.
     *
     *
     * @usage
     *
     * A simple `menuToggle` button can be added using the following markup:
     *
     * ```html
     * <button ion-button menuToggle>Toggle Menu</button>
     * ```
     *
     * To toggle a specific menu by its id or side, give the `menuToggle`
     * directive a value.
     *
     * ```html
     * <button ion-button menuToggle="right">Toggle Right Menu</button>
     * ```
     *
     * If placing the `menuToggle` in a navbar or toolbar, it should be
     * placed as a child of the `<ion-navbar>` or `<ion-toolbar>`, and not in
     * the `<ion-buttons>` element:
     *
     * ```html
     * <ion-header>
     *
     *   <ion-navbar>
     *     <ion-buttons start>
     *       <button ion-button>
     *         <ion-icon name="contact"></ion-icon>
     *       </button>
     *     </ion-buttons>
     *     <button ion-button menuToggle>
     *       <ion-icon name="menu"></ion-icon>
     *     </button>
     *     <ion-title>
     *       Title
     *     </ion-title>
     *     <ion-buttons end>
     *       <button ion-button (click)="doClick()">
     *         <ion-icon name="more"></ion-icon>
     *       </button>
     *     </ion-buttons>
     *   </ion-navbar>
     *
     * </ion-header>
     * ```
     *
     * Similar to `<ion-buttons>`, the `menuToggle` can be positioned using
     * `start`, `end`, `left`, or `right`:
     *
     * ```html
     * <ion-toolbar>
     *   <button ion-button menuToggle right>
     *     <ion-icon name="menu"></ion-icon>
     *   </button>
     *   <ion-title>
     *     Title
     *   </ion-title>
     *   <ion-buttons end>
     *     <button ion-button (click)="doClick()">
     *       <ion-icon name="more"></ion-icon>
     *     </button>
     *   </ion-buttons>
     * </ion-toolbar>
     * ```
     *
     * See the [Toolbar API docs](../../toolbar/Toolbar) for more information
     * on the different positions.
     *
     * @demo /docs/v2/demos/src/menu/
     * @see {@link /docs/v2/components#menus Menu Component Docs}
     * @see {@link ../../menu/Menu Menu API Docs}
     */
    var MenuToggle = (function () {
        function MenuToggle(_menu, _viewCtrl, _button, _navbar) {
            this._menu = _menu;
            this._viewCtrl = _viewCtrl;
            this._button = _button;
            this._navbar = _navbar;
            this._isButton = !!_button;
            this._inNavbar = !!_navbar;
        }
        MenuToggle.prototype.ngAfterContentInit = function () {
            // Add the bar-button-menutoggle / button-menutoggle class
            if (this._isButton) {
                this._button._setClass('menutoggle', true);
            }
        };
        /**
        * @private
        */
        MenuToggle.prototype.toggle = function () {
            var menu = this._menu.get(this.menuToggle);
            menu && menu.toggle();
        };
        Object.defineProperty(MenuToggle.prototype, "isHidden", {
            /**
            * @private
            */
            get: function () {
                if (this._inNavbar && this._viewCtrl) {
                    if (this._viewCtrl.isFirst()) {
                        // this is the first view, so it should always show
                        return false;
                    }
                    var menu = this._menu.get(this.menuToggle);
                    if (menu) {
                        // this is not the root view, so see if this menu
                        // is configured to still be enabled if it's not the root view
                        return !menu.persistent;
                    }
                }
                return false;
            },
            enumerable: true,
            configurable: true
        });
        MenuToggle.decorators = [
            { type: core_1.Directive, args: [{
                        selector: '[menuToggle]',
                        host: {
                            '[hidden]': 'isHidden'
                        }
                    },] },
        ];
        /** @nocollapse */
        MenuToggle.ctorParameters = [
            { type: menu_controller_1.MenuController, },
            { type: view_controller_1.ViewController, decorators: [{ type: core_1.Optional },] },
            { type: button_1.Button, decorators: [{ type: core_1.Optional },] },
            { type: navbar_1.Navbar, decorators: [{ type: core_1.Optional },] },
        ];
        MenuToggle.propDecorators = {
            'menuToggle': [{ type: core_1.Input },],
            'toggle': [{ type: core_1.HostListener, args: ['click',] },],
        };
        return MenuToggle;
    }());
    exports.MenuToggle = MenuToggle;
});
//# sourceMappingURL=menu-toggle.js.map