var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
(function (factory) {
    if (typeof module === 'object' && typeof module.exports === 'object') {
        var v = factory(require, exports); if (v !== undefined) module.exports = v;
    }
    else if (typeof define === 'function' && define.amd) {
        define(["require", "exports", '@angular/core', '../button/button', '../../config/config', '../ion', '../navbar/navbar', './toolbar'], factory);
    }
})(function (require, exports) {
    "use strict";
    var core_1 = require('@angular/core');
    var button_1 = require('../button/button');
    var config_1 = require('../../config/config');
    var ion_1 = require('../ion');
    var navbar_1 = require('../navbar/navbar');
    var toolbar_1 = require('./toolbar');
    /**
     * @private
     */
    var ToolbarItem = (function (_super) {
        __extends(ToolbarItem, _super);
        function ToolbarItem(config, elementRef, renderer, toolbar, navbar) {
            _super.call(this, config, elementRef, renderer, 'bar-buttons');
            this.inToolbar = !!(toolbar || navbar);
        }
        Object.defineProperty(ToolbarItem.prototype, "_buttons", {
            set: function (buttons) {
                if (this.inToolbar) {
                    buttons.forEach(function (button) {
                        button.setRole('bar-button');
                    });
                }
            },
            enumerable: true,
            configurable: true
        });
        ToolbarItem.decorators = [
            { type: core_1.Directive, args: [{
                        selector: 'ion-buttons,[menuToggle]'
                    },] },
        ];
        /** @nocollapse */
        ToolbarItem.ctorParameters = [
            { type: config_1.Config, },
            { type: core_1.ElementRef, },
            { type: core_1.Renderer, },
            { type: toolbar_1.Toolbar, decorators: [{ type: core_1.Optional },] },
            { type: navbar_1.Navbar, decorators: [{ type: core_1.Optional }, { type: core_1.Inject, args: [core_1.forwardRef(function () { return navbar_1.Navbar; }),] },] },
        ];
        ToolbarItem.propDecorators = {
            '_buttons': [{ type: core_1.ContentChildren, args: [button_1.Button,] },],
        };
        return ToolbarItem;
    }(ion_1.Ion));
    exports.ToolbarItem = ToolbarItem;
});
//# sourceMappingURL=toolbar-item.js.map