'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var path = require('path');
var builtins = _interopDefault(require('builtin-modules'));
var _nodeResolve = _interopDefault(require('resolve'));
var browserResolve = _interopDefault(require('browser-resolve'));

var COMMONJS_BROWSER_EMPTY = _nodeResolve.sync( 'browser-resolve/empty.js', __dirname );
var ES6_BROWSER_EMPTY = path.resolve( __dirname, '../src/empty.js' );
var CONSOLE_WARN = function () {
	var args = [], len = arguments.length;
	while ( len-- ) args[ len ] = arguments[ len ];

	return console.warn.apply( console, args );
}; // eslint-disable-line no-console

function nodeResolve ( options ) {
	options = options || {};

	var skip = options.skip || [];
	var useJsnext = options.jsnext === true;
	var useModule = options.module !== false;
	var useMain = options.main !== false;
	var isPreferBuiltinsSet = options.preferBuiltins === true || options.preferBuiltins === false;
	var preferBuiltins = isPreferBuiltinsSet ? options.preferBuiltins : true;

	var onwarn = options.onwarn || CONSOLE_WARN;
	var resolveId = options.browser ? browserResolve : _nodeResolve;

	return {
		name: 'node-resolve',

		resolveId: function resolveId$1 ( importee, importer ) {
			if ( /\0/.test( importee ) ) return null; // ignore IDs with null character, these belong to other plugins

			// disregard entry module
			if ( !importer ) return null;

			var parts = importee.split( /[\/\\]/ );
			var id = parts.shift();

			if ( id[0] === '@' && parts.length ) {
				// scoped packages
				id += "/" + (parts.shift());
			} else if ( id[0] === '.' ) {
				// an import relative to the parent dir of the importer
				id = path.resolve( importer, '..', importee );
			}

			if ( skip !== true && ~skip.indexOf( id ) ) return null;

			return new Promise( function ( accept, reject ) {
				resolveId(
					importee,
					{
						basedir: path.dirname( importer ),
						packageFilter: function packageFilter ( pkg ) {
							if ( !useJsnext && !useMain && !useModule ) {
								if ( skip === true ) accept( false );
								else reject( Error( ("To import from a package in node_modules (" + importee + "), either options.jsnext, options.module or options.main must be true") ) );
							} else if ( useModule && pkg[ 'module' ] ) {
								pkg[ 'main' ] = pkg[ 'module' ];
							} else if ( useJsnext && pkg[ 'jsnext:main' ] ) {
								pkg[ 'main' ] = pkg[ 'jsnext:main' ];
							} else if ( ( useJsnext || useModule ) && !useMain ) {
								if ( skip === true ) accept( false );
								else reject( Error( ("Package " + importee + " (imported by " + importer + ") does not have a module or jsnext:main field. You should either allow legacy modules with options.main, or skip it with options.skip = ['" + importee + "'])") ) );
							}
							return pkg;
						},
						extensions: options.extensions
					},
					function ( err, resolved ) {
						if ( err ) {
							if ( skip === true ) accept( false );
							else reject( Error( ("Could not resolve '" + importee + "' from " + (path.normalize( importer ))) ) );
						} else {
							if ( resolved === COMMONJS_BROWSER_EMPTY ) {
								accept( ES6_BROWSER_EMPTY );
							} else if ( ~builtins.indexOf( resolved ) ) {
								accept( null );
							} else if ( ~builtins.indexOf( importee ) && preferBuiltins ) {
								if ( !isPreferBuiltinsSet ) {
									onwarn(
										"preferring built-in module '" + importee + "' over local alternative " +
										"at '" + resolved + "', pass 'preferBuiltins: false' to disable this " +
										"behavior or 'preferBuiltins: true' to disable this warning"
									);
								}
								accept( null );
							} else {
								accept( resolved );
							}
						}
					}
				);
			});
		}
	};
}

module.exports = nodeResolve;