// Ionic Starter App

// angular.module is a global place for creating, registering and retrieving Angular modules
// 'starter' is the name of this angular module example (also set in a <body> attribute in index.html)
// the 2nd parameter is an array of 'requires'
// 'starter.services' is found in services.js
// 'starter.controllers' is found in controllers.js
angular.module('starter', ['ionic', 'starter.controllers', 'starter.services', 'starter.utils', 'ngStorage', 'ngCordova', 'ui.router'])//
    .constant('constants', {

        // URLS
        url: "http://www.feqhiat.com/ws.php?",
        all_data: "http://www.feqhiat.com/ws.php?cmd=getAllData",//"data/allData.json",//
        param_url : "http://www.feqhiat.com/ws.php?cmd=getAllParam",//"data/allParams.json",//
        problem_list : "http://www.feqhiat.com/ws.php?cmd=getProblemsByCount",//"data/problemList.json",//
        problem_solutions : "http://www.feqhiat.com/ws.php?cmd=getProblemSolutions",//"data/problemSolutions.json",//
        send_problem : "http://www.feqhiat.com/ws.php?cmd=addProblem",//url+"cmd=addProblem",
        newsList : "",//url+"cmd=getAllNews",
        getItemsCount : "data/itemCount.json",//url+"cmd=getItemsCount",
        getBooksCount : "data/bookCount.json",//url+"cmd=getBooksCount",
        getChaptersCount : "data/chapterCount.json",//url+"cmd=getChaptersCount",
        saveSolution : "",//url+"cmd=saveSolution",

        //url: "data/allData.json",//"http://feqhiat.com/ws.php?",
        device_id: "",
        is_admin: false,
        user_name: "",
        app_version : "0.4"

    })

.run(function($ionicPlatform) {
  $ionicPlatform.ready(function() {
    // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
    // for form inputs)
    if (window.cordova && window.cordova.plugins && window.cordova.plugins.Keyboard) {
      cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
      cordova.plugins.Keyboard.disableScroll(true);

    }
    if (window.StatusBar) {
      // org.apache.cordova.statusbar required
      StatusBar.styleDefault();
    }
  });
})

.config(function($stateProvider, $urlRouterProvider) {

  // Ionic uses AngularUI Router which uses the concept of states
  // Learn more here: https://github.com/angular-ui/ui-router
  // Set up the various states which the app can be in.
  // Each state's controller can be found in controllers.js
  $stateProvider

  // setup an abstract state for the tabs directive
    .state('tab', {
    url: '/tab',
    abstract: true,
    templateUrl: 'templates/tabs.html'
  })

  // Each tab has its own nav history stack:

  .state('tab.main', {
    url: '/main',
    views: {
      'tab-main': {
        templateUrl: 'templates/tab-main.html',
        controller: 'MainCtrl'
      }
    }
  })

  .state('tab.search', {
      url: '/search',
      views: {
        'tab-search': {
          templateUrl: 'templates/tab-search.html',
          controller: 'SearchCtrl'
        }
      }
    })

  .state('tab.send', {
    url: '/send',
    views: {
      'tab-send': {
        templateUrl: 'templates/tab-send.html',
        controller: 'SendCtrl'
      }
    }
  })

      .state('tab.answer', {
          url: '/send',
          views: {
              'tab-send': {
                  templateUrl: 'templates/answer.html',
                  controller: 'AnswerCtrl'
              }
          }
      })

    .state('tab.recent', {
      url: '/recent',
      views: {
        'tab-recent': {
          templateUrl: 'templates/tab-recent.html',
          controller: 'RecentCtrl'
        }
      }
    })

    .state('tab.about', {
      url: '/about',
      views: {
        'tab-about': {
          templateUrl: 'templates/tab-about.html',
          controller: 'AboutCtrl'
        }
      }
    })

      .state('tab.books', {
          url: '/main/:itemId',
          views: {
              'tab-main': {
                  templateUrl: 'templates/books.html',
                  controller: 'BookCtrl'
              }
          }
      })

      .state('tab.chapters', {
          url: '/books/:itemId',
          views: {
              'tab-main': {
                  templateUrl: 'templates/chapters.html',
                  controller: 'ChapterCtrl'
              }
          }
      })

      .state('tab.problem_list', {
          url: '/problem_list/:bookId',
          views: {
              'tab-main': {
                  templateUrl: 'templates/problem_list.html',
                  controller: 'ProblemListCtrl'
              }
          }
      })

    .state('tab.singleProblem', {
        url: '/singleProblem/:problemId',
        views: {
            'tab-main': {
                templateUrl: 'templates/singleProblem.html',
                controller: 'ProblemCtrl'
            }
        }
    });

  // if none of the above states are matched, use this as the fallback
  $urlRouterProvider.otherwise('/tab/main');

});
